package com.agilex.healthcare.directscheduling.domain.facility;

import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import com.agilex.healthcare.directscheduling.domain.Namespace;

@XmlRootElement(name = "provider", namespace = Namespace.DirectScheduling)
@XmlAccessorType(value = XmlAccessType.NONE)
public class DSFacilityProvider {
	
	private String providerId ; 
	private String firstName ; 
	private String lastName ;
	private String providerClass ; 
	private String providerNamePrefix ; 
	private String providerNameSuffix  ; 
	
	@XmlElement
	public String getProviderId() {
		return providerId;
	}
	public void setProviderId(String providerId) {
		this.providerId = providerId;
	}
	
	@XmlElement
	public String getFirstName() {
		return firstName;
	}
	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}
	
	@XmlElement
	public String getLastName() {
		return lastName;
	}
	public void setLastName(String lastName) {
		this.lastName = lastName;
	}  
	
	@XmlElement
	public String getProviderClass() {
		return providerClass;
	}
	
	public void setProviderClass(String providerClass) {
		this.providerClass = providerClass;
	}
	
	@XmlElement
	public String getProviderNamePrefix() {
		return providerNamePrefix;
	}
	public void setProviderNamePrefix(String providerNamePrefix) {
		this.providerNamePrefix = providerNamePrefix;
	}
	
	@XmlElement
	public String getProviderNameSuffix() {
		return providerNameSuffix;
	}
	public void setProviderNameSuffix(String providerNameSuffix) {
		this.providerNameSuffix = providerNameSuffix;
	}
	
	@Override
	public boolean equals(Object obj) {

		if( ! ( obj instanceof DSFacilityProvider ) ) { 
			
			return( false ) ;  
		}
		
		DSFacilityProvider tempProvider = ( DSFacilityProvider )obj ; 
		return( providerId.equalsIgnoreCase( tempProvider.getProviderId( ) ) ) ; 
	}
	
	@Override
	public int hashCode() {
		
		return( providerId.toLowerCase( ).hashCode() ) ; 
	}
	

	public String toString( ) { 
		
		StringBuffer sb = new StringBuffer( ) ; 
		
		sb.append( "providerId=" ).append( providerId ).append( "\t" ) ; 
		sb.append( "lastName=" ).append( lastName ).append( "\t" ) ; 
		sb.append( "firstName=" ).append( firstName ) ; 
		
		return( sb.toString( ) ) ;
	}
	

}
